-- Drop tables

DROP TABLE IF EXISTS it_tickets CASCADE;
DROP TABLE IF EXISTS users CASCADE;
DROP TABLE IF EXISTS roles CASCADE;
DROP TABLE IF EXISTS it_staff CASCADE;
DROP TABLE IF EXISTS stations CASCADE;
DROP TABLE IF EXISTS computers CASCADE;
DROP TABLE IF EXISTS laboratories CASCADE;
DROP TABLE IF EXISTS accessories CASCADE;


-- Create tables with PK

CREATE TABLE users (
user_id INTEGER NOT NULL,
role_id INTEGER,
user_password VARCHAR(50),
user_email VARCHAR(50),
user_firstname VARCHAR(50),
user_lastname VARCHAR(50),
user_phone VARCHAR(15),
created_at DATE,
updated_at DATE,
PRIMARY KEY (user_id)
);

CREATE TABLE accessories (
acc_id INTEGER NOT NULL,
station_id INTEGER,
acc_manufacturer VARCHAR(50),
acc_operational BOOLEAN,
acc_purchdate DATE,
acc_serialno VARCHAR(15),
acc_model VARCHAR(50),
acc_type VARCHAR(15),
PRIMARY KEY (acc_id)
);

CREATE TABLE laboratories (
lab_id INT,
staff_id INT,
lab_capacity INT,
lab_phone VARCHAR(15),
lab_address VARCHAR(50),
lab_desc VARCHAR(50),
PRIMARY KEY (lab_id)
);

CREATE TABLE computers (
pc_id INT,
station_id INT,
pc_model VARCHAR(50),
pc_manufacturer VARCHAR(50),
pc_operational BOOLEAN,
pc_purchdate DATE,
pc_serialno VARCHAR(50),
pc_opsystem VARCHAR(50),
PRIMARY KEY (pc_id)
);

CREATE TABLE it_tickets (
it_ticket INT,
staff_id INT,
user_id INT,
station_id INT,
ticket_desc VARCHAR(50),
ticket_status BOOLEAN,
ticket_date DATE,
PRIMARY KEY (it_ticket)
);

CREATE TABLE stations (
station_id INT,
lab_id INT,
PRIMARY KEY (station_id)
);

CREATE TABLE it_staff (
staff_id INT,
it_ticket INT,
staff_firstname VARCHAR(50),
staff_lastname VARCHAR(50),
staff_email VARCHAR(50),
staff_password VARCHAR(50),
staff_address VARCHAR(50),
staff_phone VARCHAR(15),
PRIMARY KEY (staff_id)
);

CREATE TABLE roles (
role_id INT,
role_name VARCHAR(50),
role_desc VARCHAR(50),
role_startdate DATE,
role_enddate DATE,
PRIMARY KEY (role_id)
);



-- Add values to accessories table

INSERT INTO accessories(acc_id,station_id,acc_manufacturer,acc_operational,acc_purchdate,acc_serialno,acc_model,acc_type) VALUES (369258,10101,'Logitech','TRUE','2021-01-29','A45156FS856','8995BE41','Printer');
INSERT INTO accessories(acc_id,station_id,acc_manufacturer,acc_operational,acc_purchdate,acc_serialno,acc_model,acc_type) VALUES (258147,10102,'Corsair','FALSE','2021-01-30','A45156FS857','8995BE42','Projector');
INSERT INTO accessories(acc_id,station_id,acc_manufacturer,acc_operational,acc_purchdate,acc_serialno,acc_model,acc_type) VALUES (741852,10201,'Logitech','TRUE','2021-01-31','A45156FS858','8995BE43','Printer');
INSERT INTO accessories(acc_id,station_id,acc_manufacturer,acc_operational,acc_purchdate,acc_serialno,acc_model,acc_type) VALUES (963852,10301,'Razer','TRUE','2021-02-01','A45156FS859','8995BE44','Mouse');
INSERT INTO accessories(acc_id,station_id,acc_manufacturer,acc_operational,acc_purchdate,acc_serialno,acc_model,acc_type) VALUES (167895,10401,'HyperX','TRUE','2021-02-02','A45156FS860','8995BE45','Keyboard');
INSERT INTO accessories(acc_id,station_id,acc_manufacturer,acc_operational,acc_purchdate,acc_serialno,acc_model,acc_type) VALUES (264789,10501,'Microsoft','FALSE','2021-02-03','A45156FS861','8995BE46','Mouse');
INSERT INTO accessories(acc_id,station_id,acc_manufacturer,acc_operational,acc_purchdate,acc_serialno,acc_model,acc_type) VALUES (236541,10502,'SteelSeries','TRUE','2021-02-04','A45156FS862','8995BE47','Keyboard');
INSERT INTO accessories(acc_id,station_id,acc_manufacturer,acc_operational,acc_purchdate,acc_serialno,acc_model,acc_type) VALUES (254698,10601,'Razer','FALSE','2021-02-05','A45156FS863','8995BE48','Monitor');
INSERT INTO accessories(acc_id,station_id,acc_manufacturer,acc_operational,acc_purchdate,acc_serialno,acc_model,acc_type) VALUES (124785,10701,'Dell','FALSE','2021-02-06','A45156FS864','8995BE49','Monitor');
INSERT INTO accessories(acc_id,station_id,acc_manufacturer,acc_operational,acc_purchdate,acc_serialno,acc_model,acc_type) VALUES (985636,10801,'Lenovo','FALSE','2021-02-07','A45156FS865','8995BE50','Monitor');


-- Add values to it_tickets table

INSERT INTO it_tickets(it_ticket,staff_id,user_id,station_id,ticket_desc,ticket_status,ticket_date) VALUES (20031,26276811,35365501,10101,'Device doesn''t turn on','TRUE','2021-04-29');
INSERT INTO it_tickets(it_ticket,staff_id,user_id,station_id,ticket_desc,ticket_status,ticket_date) VALUES (20032,26276812,35365502,10102,'Broken','FALSE','2021-03-04');
INSERT INTO it_tickets(it_ticket,staff_id,user_id,station_id,ticket_desc,ticket_status,ticket_date) VALUES (20033,26276813,35365503,10201,'Unable to log in','TRUE','2021-04-25');
INSERT INTO it_tickets(it_ticket,staff_id,user_id,station_id,ticket_desc,ticket_status,ticket_date) VALUES (20034,26276814,35365504,10301,'Device doesn''t turn on','TRUE','2021-04-15');
INSERT INTO it_tickets(it_ticket,staff_id,user_id,station_id,ticket_desc,ticket_status,ticket_date) VALUES (20035,26276815,35365505,10401,'Need driver update','TRUE','2021-04-12');
INSERT INTO it_tickets(it_ticket,staff_id,user_id,station_id,ticket_desc,ticket_status,ticket_date) VALUES (20036,26276816,35365506,10501,'Need driver update','FALSE','2021-01-23');
INSERT INTO it_tickets(it_ticket,staff_id,user_id,station_id,ticket_desc,ticket_status,ticket_date) VALUES (20037,26276817,35365507,10502,'Error screen','TRUE','2021-01-14');
INSERT INTO it_tickets(it_ticket,staff_id,user_id,station_id,ticket_desc,ticket_status,ticket_date) VALUES (20038,26276818,35365508,10601,'Unable to connect to internet','FALSE','2021-03-25');
INSERT INTO it_tickets(it_ticket,staff_id,user_id,station_id,ticket_desc,ticket_status,ticket_date) VALUES (20039,26276819,35365509,10701,'Account needs role update','FALSE','2021-02-28');
INSERT INTO it_tickets(it_ticket,staff_id,user_id,station_id,ticket_desc,ticket_status,ticket_date) VALUES (20040,26276820,35365510,10801,'Check in','FALSE','2021-05-22');

--Add values to users table

INSERT INTO users(user_id,role_id,user_password,user_email,user_firstname,user_phone,created_at,updated_at) VALUES (35365501,4801,'Ai!hcip1999','jjson@aol.com','John',3125555501,'2002-03-01','2021-01-15');
INSERT INTO users(user_id,role_id,user_password,user_email,user_firstname,user_phone,created_at,updated_at) VALUES (35365502,4802,'Ai!hcip2000','jgdal@msn.com','Jane',3125554862,'2005-04-04','2021-01-16');
INSERT INTO users(user_id,role_id,user_password,user_email,user_firstname,user_phone,created_at,updated_at) VALUES (35365503,4803,'Ai!hcip2001','jbezo@mailinator.com','Jeff',8882804331,'2006-02-19','2021-01-17');
INSERT INTO users(user_id,role_id,user_password,user_email,user_firstname,user_phone,created_at,updated_at) VALUES (35365504,4804,'Ai!hcip2002','hstyle@gmail.com','Harry',2556552783,'2010-10-10','2021-01-18');
INSERT INTO users(user_id,role_id,user_password,user_email,user_firstname,user_phone,created_at,updated_at) VALUES (35365505,4805,'Ai!hcip2003','lluth@ymail.com','Lex',7758856645,'2015-12-09','2021-01-19');
INSERT INTO users(user_id,role_id,user_password,user_email,user_firstname,user_phone,created_at,updated_at) VALUES (35365506,4806,'Ai!hcip2004','bwayn@yahoo.com','Bruce',3221564875,'2015-09-18','2021-01-20');
INSERT INTO users(user_id,role_id,user_password,user_email,user_firstname,user_phone,created_at,updated_at) VALUES (35365507,4807,'Ai!hcip2005','djohn@msn.com','Dwayne',7532894568,'2020-11-14','2021-01-21');
INSERT INTO users(user_id,role_id,user_password,user_email,user_firstname,user_phone,created_at,updated_at) VALUES (35365508,4808,'Ai!hcip2006','tturn@yearup.org','Timmy',1234567890,'2019-05-13','2021-01-22');
INSERT INTO users(user_id,role_id,user_password,user_email,user_firstname,user_phone,created_at,updated_at) VALUES (35365509,4809,'Ai!hcip2007','vdies@gmail.com','Vin',9876543210,'2017-06-17','2021-01-23');
INSERT INTO users(user_id,role_id,user_password,user_email,user_firstname,user_phone,created_at,updated_at) VALUES (35365510,4810,'Ai!hcip2008','csand@ymail.com','Carmen',6543219875,'2013-07-06','2021-01-24');

--Add values to roles table

INSERT INTO roles(role_id,role_name,role_desc,role_startdate,role_enddate) VALUES (4801,'admin','IT Staff','2002-03-01','2018-05-06');
INSERT INTO roles(role_id,role_name,role_desc,role_startdate,role_enddate) VALUES (4802,'student','Guest User','2005-04-04','2021-05-14');
INSERT INTO roles(role_id,role_name,role_desc,role_startdate,role_enddate) VALUES (4803,'visitor','Visitors (limited access)','2006-02-19','2006-02-19');
INSERT INTO roles(role_id,role_name,role_desc,role_startdate,role_enddate) VALUES (4804,'teacher','BE Instructor','2010-10-10','2021-10-09');
INSERT INTO roles(role_id,role_name,role_desc,role_startdate,role_enddate) VALUES (4805,'directive','Non IT Admin','2015-12-09','2021-01-01');
INSERT INTO roles(role_id,role_name,role_desc,role_startdate,role_enddate) VALUES (4806,'admin','IT Staff','2015-09-18','2021-05-06');
INSERT INTO roles(role_id,role_name,role_desc,role_startdate,role_enddate) VALUES (4807,'student','Guest User','2020-11-14','2021-05-03');
INSERT INTO roles(role_id,role_name,role_desc,role_startdate,role_enddate) VALUES (4808,'visitor','Visitors (limited access)','2019-05-13','2019-05-14');
INSERT INTO roles(role_id,role_name,role_desc,role_startdate,role_enddate) VALUES (4809,'teacher','DA Instructor','2017-06-17','2021-03-02');
INSERT INTO roles(role_id,role_name,role_desc,role_startdate,role_enddate) VALUES (4810,'directive','Non IT Admin','2013-07-06','2021-02-14');

--Add values to it_staff table

INSERT INTO IT_Staff(staff_id,it_ticket,staff_firstname,staff_lastname,staff_email,staff_password,staff_address,staff_phone) 
VALUES (26276811,20031,'Greg','Lucas','dprice@yu.edu','Sndy49@#$%','337 Meadow Lane, Chicago, IL, 60657','8245554863');
INSERT INTO IT_Staff(staff_id,it_ticket,staff_firstname,staff_lastname,staff_email,staff_password,staff_address,staff_phone) 
VALUES (26276812,20032,'Susan','Garcia','staikos@yu.edu','hiGYUO@#$%','588 S Lane, Chicago, IL, 60611','3124564444');
INSERT INTO IT_Staff(staff_id,it_ticket,staff_firstname,staff_lastname,staff_email,staff_password,staff_address,staff_phone) 
VALUES (26276813,20033,'Mina','Mendoza','psharpe@yu.edu','NJI78@#$%','112 N Ellis, Chicago, IL, 60612','3124894561');
INSERT INTO IT_Staff(staff_id,it_ticket,staff_firstname,staff_lastname,staff_email,staff_password,staff_address,staff_phone) 
VALUES (26276814,20034,'Leslie','Rojas','andale@yu.edu','Bhgip468%^','4674  Point Street, Chicago, IL, 60611','5488886123');
INSERT INTO IT_Staff(staff_id,it_ticket,staff_firstname,staff_lastname,staff_email,staff_password,staff_address,staff_phone) 
VALUES (26276815,20035,'Ashley','Hernandez','magusnet@yu.edu','BOVG5&%','858 S Surf St, Chicago, IL, 60622','8724564562');
INSERT INTO IT_Staff(staff_id,it_ticket,staff_firstname,staff_lastname,staff_email,staff_password,staff_address,staff_phone) 
VALUES (26276816,20036,'Alex','Smith','hillct@yu.edu','Ui878$#12','45 S Meadow Lane, Chicago, IL, 60657','2144584562');
INSERT INTO IT_Staff(staff_id,it_ticket,staff_firstname,staff_lastname,staff_email,staff_password,staff_address,staff_phone) 
VALUES (26276817,20037,'Bob','Esponja','dunstan@yu.edu','Ui878$#13','77 N Ellis, Chicago, IL, 60612','5488558888');
INSERT INTO IT_Staff(staff_id,it_ticket,staff_firstname,staff_lastname,staff_email,staff_password,staff_address,staff_phone) 
VALUES (26276818,20038,'Jorge','Stevens','tmccarth@yu.edu','Ui878$#14','88 S Lane, Chicago, IL, 60611','9885234532');
INSERT INTO IT_Staff(staff_id,it_ticket,staff_firstname,staff_lastname,staff_email,staff_password,staff_address,staff_phone) 
VALUES (26276819,20039,'Daniel','Graves','msroth@yu.edu','Ui878$#15','7 Point Street, Chicago, IL, 60611','7858564568');
INSERT INTO IT_Staff(staff_id,it_ticket,staff_firstname,staff_lastname,staff_email,staff_password,staff_address,staff_phone) 
VALUES (26276820,20040,'Sarai','Gates','bader@yu.edu','Ui878$#16','855 Meadow Lane, Chicago, IL, 60657','3128569665');


--Add values to stations table

INSERT INTO Stations(station_id,lab_id) 
VALUES (10101,101);
INSERT INTO Stations(station_id,lab_id) 
VALUES (10102,101);
INSERT INTO Stations(station_id,lab_id) 
VALUES (10201,102);
INSERT INTO Stations(station_id,lab_id) 
VALUES (10301,103);
INSERT INTO Stations(station_id,lab_id) 
VALUES (10401,104);
INSERT INTO Stations(station_id,lab_id) 
VALUES (10501,105);
INSERT INTO Stations(station_id,lab_id) 
VALUES (10502,105);
INSERT INTO Stations(station_id,lab_id) 
VALUES (10601,106);
INSERT INTO Stations(station_id,lab_id) 
VALUES (10701,107);
INSERT INTO Stations(station_id,lab_id) 
VALUES (10801,108);

--Add values to computers table

INSERT INTO Computers(pc_id,station_id,pc_model,pc_manufacturer,pc_operational,pc_purchdate,pc_serialno,pc_opsystem) 
VALUES (1001,10101,'2236EG1','Dell','TRUE','2021-01-15','4CE156FSD25','Windows');
INSERT INTO Computers(pc_id,station_id,pc_model,pc_manufacturer,pc_operational,pc_purchdate,pc_serialno,pc_opsystem) 
VALUES (1002,10102,'2236EG2','HP','FALSE','2021-01-16','4CE156FSD26','macOS');
INSERT INTO Computers(pc_id,station_id,pc_model,pc_manufacturer,pc_operational,pc_purchdate,pc_serialno,pc_opsystem) 
VALUES (1003,10201,'2236EG3','Apple','TRUE','2021-01-17','4CE156FSD27','Windows');
INSERT INTO Computers(pc_id,station_id,pc_model,pc_manufacturer,pc_operational,pc_purchdate,pc_serialno,pc_opsystem) 
VALUES (1004,10301,'2236EG4','Dell','TRUE','2021-01-18','4CE156FSD28','macOS');
INSERT INTO Computers(pc_id,station_id,pc_model,pc_manufacturer,pc_operational,pc_purchdate,pc_serialno,pc_opsystem) 
VALUES (1005,10401,'2236EG5','Lenovo','TRUE','2021-01-19','4CE156FSD29','Windows');
INSERT INTO Computers(pc_id,station_id,pc_model,pc_manufacturer,pc_operational,pc_purchdate,pc_serialno,pc_opsystem) 
VALUES (1006,10501,'2236EG6','Dell','FALSE','2021-01-20','4CE156FSD30','macOS');
INSERT INTO Computers(pc_id,station_id,pc_model,pc_manufacturer,pc_operational,pc_purchdate,pc_serialno,pc_opsystem) 
VALUES (1007,10502,'2236EG7','Apple','TRUE','2021-01-21','4CE156FSD31','Windows');
INSERT INTO Computers(pc_id,station_id,pc_model,pc_manufacturer,pc_operational,pc_purchdate,pc_serialno,pc_opsystem) 
VALUES (1008,10601,'2236EG8','Dell','FALSE','2021-01-22','4CE156FSD32','macOS');
INSERT INTO Computers(pc_id,station_id,pc_model,pc_manufacturer,pc_operational,pc_purchdate,pc_serialno,pc_opsystem) 
VALUES (1009,10701,'2236EG9','Lenovo','FALSE','2021-01-23','4CE156FSD33','Windows');
INSERT INTO Computers(pc_id,station_id,pc_model,pc_manufacturer,pc_operational,pc_purchdate,pc_serialno,pc_opsystem) 
VALUES (1010,10801,'2236EG10','HP','FALSE','2021-01-24','4CE156FSD34','macOS');


--Add values to laboratories table

INSERT INTO Laboratories(lab_id,staff_id,lab_capacity,lab_phone,lab_address,lab_desc) 
VALUES (101,26276811,100,'3128552101','225 M State Ave, Chicago, IL, 60625','DA');
INSERT INTO Laboratories(lab_id,staff_id,lab_capacity,lab_phone,lab_address,lab_desc) 
VALUES (102,26276812,100,'3128552102','225 M State Ave, Chicago, IL, 60625','IT');
INSERT INTO Laboratories(lab_id,staff_id,lab_capacity,lab_phone,lab_address,lab_desc) 
VALUES (103,26276813,150,'3128552103','225 M State Ave, Chicago, IL, 60625','BE');
INSERT INTO Laboratories(lab_id,staff_id,lab_capacity,lab_phone,lab_address,lab_desc) 
VALUES (104,26276814,50,'3128552104','226 M State Ave, Chicago, IL, 60625','DA');
INSERT INTO Laboratories(lab_id,staff_id,lab_capacity,lab_phone,lab_address,lab_desc) 
VALUES (105,26276815,200,'3128552105','227 M State Ave, Chicago, IL, 60625','IT');
INSERT INTO Laboratories(lab_id,staff_id,lab_capacity,lab_phone,lab_address,lab_desc) 
VALUES (106,26276816,100,'3128552106','228 M State Ave, Chicago, IL, 60625','BE');
INSERT INTO Laboratories(lab_id,staff_id,lab_capacity,lab_phone,lab_address,lab_desc) 
VALUES (107,26276817,150,'3128552107','229 M State Ave, Chicago, IL, 60625','DA');
INSERT INTO Laboratories(lab_id,staff_id,lab_capacity,lab_phone,lab_address,lab_desc) 
VALUES (108,26276818,50,'3128552108','230 M State Ave, Chicago, IL, 60625','IT');

--Add Foreign Keys

ALTER TABLE accessories
ADD CONSTRAINT station_fk
FOREIGN KEY (station_id)
REFERENCES stations(station_id);

ALTER TABLE computers
ADD CONSTRAINT station_fk
FOREIGN KEY (station_id)
REFERENCES stations(station_id);

ALTER TABLE it_tickets
ADD CONSTRAINT station_fk
FOREIGN KEY (station_id)
REFERENCES stations(station_id);

ALTER TABLE it_tickets
ADD CONSTRAINT staff_pk
FOREIGN KEY (staff_id)
REFERENCES it_staff(staff_id);

ALTER TABLE it_tickets
ADD CONSTRAINT user_fk
FOREIGN KEY (user_id)
REFERENCES users(user_id);

ALTER TABLE stations
ADD CONSTRAINT lab_fk
FOREIGN KEY (lab_id)
REFERENCES laboratories(lab_id);

ALTER TABLE laboratories
ADD CONSTRAINT staff_fk
FOREIGN KEY (staff_id)
REFERENCES it_staff(staff_id);

ALTER TABLE it_staff
ADD CONSTRAINT ticket_fk
FOREIGN KEY (it_ticket)
REFERENCES it_tickets(it_ticket);

